<?php
/**
 * Developer : MahdiY
 * Web Site  : MahdiY.IR
 * E-Mail    : M@hdiY.IR
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class PWS_Version {

	public function __construct() {

		$current_version = get_option( 'pws_version', '2.1.6' );

		if ( $current_version == PWS_VERSION ) {
			return true;
		}

		$current_version = (int) str_replace( '.', '', $current_version );
		$pws_version     = (int) str_replace( '.', '', PWS_VERSION );

		for ( $version = $current_version; $version <= $pws_version; $version ++ ) {
			if ( method_exists( $this, "update_{$version}" ) ) {
				$this->{"update_{$version}"}();
			}
		}

		update_option( "pws_version", PWS_VERSION );
	}

	public function update_219() {
		global $wpdb;

		// Update zone methods

		$table = $wpdb->prefix . 'woocommerce_shipping_zone_methods';

		$sql = "SELECT * FROM {$table}";

		$methods = $wpdb->get_results( $sql );

		foreach ( $methods as $method ) {

			if ( $method->method_id != 'WC_Tapin_Method' ) {
				continue;
			}

			$settings = get_option( "woocommerce_WC_Tapin_Method_{$method->instance_id}_settings" );

			if ( $settings['post_type'] == 1 ) {
				$new_method = 'Tapin_Pishtaz_Method';
			} else {
				$new_method = 'Tapin_Sefareshi_Method';
			}

			unset( $settings['post_type'] );

			if ( isset( $settings['pay_type'] ) ) {
				unset( $settings['pay_type'] );
			}

			if ( isset( $settings['default_weight'] ) ) {
				unset( $settings['default_weight'] );
			}

			if ( isset( $settings['package_weight'] ) ) {
				unset( $settings['package_weight'] );
			}

			if ( isset( $settings['post_gateway'] ) ) {
				unset( $settings['post_gateway'] );
			}

			$wpdb->update( $table, [
				'method_id' => $new_method
			], [
				'zone_id'     => $method->zone_id,
				'instance_id' => $method->instance_id
			] );

			update_option( "woocommerce_{$new_method}_{$method->instance_id}_settings", $settings );
			delete_option( "woocommerce_WC_Tapin_Method_{$method->instance_id}_settings" );
		}

		// Update order shipping method

		$order_items    = $wpdb->prefix . 'woocommerce_order_items';
		$order_itemmeta = $wpdb->prefix . 'woocommerce_order_itemmeta';

		$sql = "SELECT * FROM {$wpdb->postmeta} WHERE `meta_key` = 'tapin_method'";

		$post_meta = $wpdb->get_results( $sql );

		$post_meta = wp_list_pluck( $post_meta, 'meta_value', 'post_id' );

		if ( ! count( $post_meta ) ) {
			return true;
		}

		$order_ids = implode( ',', array_keys( $post_meta ) );

		$sql = "SELECT * FROM {$order_itemmeta} INNER JOIN {$order_items}
				WHERE {$order_itemmeta}.meta_value = 'WC_Tapin_Method'
				AND {$order_items}.`order_item_type` = 'shipping'
				AND {$order_items}.`order_id` IN ({$order_ids})";

		$items = $wpdb->get_results( $sql );

		$items = wp_list_pluck( $items, 'meta_id', 'order_id' );

		foreach ( $post_meta as $order_id => $settings ) {

			$settings = unserialize( $settings );

			if ( $settings['post_type'] == 1 ) {
				$new_method = 'Tapin_Pishtaz_Method';
			} else {
				$new_method = 'Tapin_Sefareshi_Method';
			}

			$wpdb->update( $order_itemmeta, [
				'meta_value' => $new_method
			], [
				'meta_id' => $items[ $order_id ]
			] );

			delete_post_meta( $order_id, 'tapin_method' );
		}

	}

	public function update_220() {
		// Update settings

		if ( ! function_exists( 'PW' ) ) {
			return true;
		}

		$keys = [
			// Tools
			'pws_status_enable'       => 'tools.status_enable',
			'pws_hide_when_free'      => 'tools.hide_when_free',
			'pws_hide_when_courier'   => 'tools.hide_when_courier',

			// Tapin
			'pws_tapin_enable'        => 'tapin.enable',
			'pws_tapin_enable_credit' => 'tapin.show_credit',
			'pws_tapin_gateway'       => 'tapin.gateway',
			'pws_product_weight'      => 'tapin.product_weight',
			'pws_package_weight'      => 'tapin.package_weight',
			'pws_tapin_token'         => 'tapin.token',
			'pws_tapin_shop_id'       => 'tapin.shop_id',
		];

		foreach ( $keys as $old_key => $new_key ) {

			$value = PW()->get_options( $old_key );
			$value = str_replace( 'yes', 1, $value );
			$value = str_replace( 'no', 0, $value );
			PWS()->set_option( $new_key, $value );

		}

	}
}

add_action( 'init', function () {
	new PWS_Version();
} );
