<?php
namespace Persian_Flatsome;

class Promotion {
	private $parent_menu;
	private $text_domain;
	private $path;
	private static $_instance;
	/**
	 * Promotion constructor.
	 */
	private function __construct($parent_menu, $text_domain, $path) {
		$this->parent_menu = $parent_menu;
		$this->text_domain = $text_domain;
		$this->path = $path;

		add_action('admin_menu', [$this, 'add_menu'], 99);
	}

	public function add_menu() {
		add_submenu_page(
			$this->parent_menu,
			 __('Our promotion for you', $this->text_domain),
            sprintf(__('Special promotions %sNew%s', $this->text_domain), '<span class="awaiting-mod">', '</span>'),
			'manage_options',
			sprintf('%s-promotion', $this->parent_menu),
			array($this, 'menu_content')
		);
	}

	public function menu_content() {
		$body = array(
			'product' => Activator::$name,
			'campaign_source' => 'self_ads',
			'campaign_medium' => 'promotion',
			'campaign_name' => Activator::$name,
		);
		$response = wp_remote_post( Activator::$base_url . '/promotion', array( 'body' => wp_json_encode( $body ) ) );

		if ( is_wp_error( $response ) ) {
			$error_message = $response->get_error_message();
			$promotions = [];
		} else {
			$promotions = json_decode(wp_remote_retrieve_body($response));
		}
		include $this->path.'view/promotion-content.php';
	}


	/**
	 * Main Class Instance.
	 *
	 * Ensures only one instance of this class is loaded or can be loaded.
	 *
	 * @static
	 * @return self - Main instance.
	 */
	public static function instance($parent_menu, $text_domain, $path) {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self($parent_menu, $text_domain, $path);
		}
		return self::$_instance;
	}
}
